'use strict';

angular.module('genisis').controller('requestTypeCtrl', ['$scope', 'api',
  '$window', 'user', '$location',
  function ($scope, $api, $window, $user, $location) {
    function requestTypesByRole() {
      return $api.retrieve('requestTypes/' + $user.username(), {})
        .then(function (requestType) {
          if (requestType.success && requestType.response) {
            if (requestType.response instanceof Array) {
              $scope.requestTypes = requestType.response;
            } else {
              $scope.requestTypes = [requestType.response];
            }
          } else {
            $window.alert(requestType.message);
          }
        });
    }

    $scope.nextPage = function nextPage(choice) {
      if (!choice) {
        $window.alert(
          'Please Select a request type from the drop down menu above.'
        );
      } else if (choice.id === 1) {
        $location.path('/createRequest');
      } else if (choice.id === 2) {
        $location.path('/createToVinciRequest');
      } else {
        $window.alert(
          'Please Select a valid request type from the drop down menu above.'
        );
      }
    };

    requestTypesByRole();
  }
]);